#include <UAW API.h>



enum StringID : UAW_Extension_StringID {
	extensionName,
	extensionAuthor,
	extensionUrl,
	extensionDescription,
};

// Returns a string in UAW’s current language.
UAW_Char const * UAW_CALL stringFromStringID(
	UAW_Extension const *  extension, // explained later
	UAW_Extension_StringID id
) {
	switch(id) {
		case extensionName:
			return u"Sample Extension";
		case extensionAuthor:
			return u"Someone";
		case extensionUrl:
			return u"http://example.com";
		case extensionDescription:
			return u"Demonstrates the implementation of a basic UAW extension.";
		default:
			return u"YOU FORGOT TO DEFINE THIS STRING!";
	}
}


extern "C" __declspec(dllexport) int UAW_CALL UAW_EXTENSION_CREATE(
	UAW_API_Extension *       uaw,
	UAW_Extension_Callbacks * result,
	void *                    legacyPleaseIgnore
) {
	// If you work object-oriented, create an instance and store its address here.
	// It will be passed back to you with every callback.
	result->implementation = nullptr;

	// If you need a chance to clean up before UAW quits, place your callback here.
	result->unload = nullptr;

	// For display in the Extensions menu (from the Strings chapter sample):
	result->string      = &stringFromStringID;
	result->name        = extensionName;
	result->author      = extensionAuthor;
	result->url         = extensionUrl;
	result->description = extensionDescription;

	return 1; // success (zero for failure)
}